/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.utils;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtils {
    public static final String SEPARATOR = File.separator;
    private static final long LOCK_WAIT = 100L;
    private static final long LOCK_TIMEOUT = 5000L;

    public static String[] getJarFilelist(String dirname) {
        File dir = new File(dirname);
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".jar") || name.endsWith(".zip");
            }
        };
        return dir.list(filter);
    }

    public static String[] getWfClassFilelist(String dirname, final String wfId) {
        File dir = new File(dirname);
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith(wfId) && name.endsWith(".class");
            }
        };
        return dir.list(filter);
    }

    public static String[] getAllFilelist(String dirname) {
        File dir = new File(dirname);
        return dir.list();
    }

    public static File[] getDirlist(String dirname) {
        File dir = new File(dirname);
        FileFilter filter = new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        };
        return dir.listFiles(filter);
    }

    public static void printArray(String[] array) {
        for (int i = 0; i < array.length; ++i) {
            System.out.println(array[i]);
        }
    }

    public static void printFileArray(File[] array) {
        for (int i = 0; i < array.length; ++i) {
            System.out.println(array[i].getName());
        }
    }

    public static String getFileContent(File file) throws FileNotFoundException, IOException {
        return FileUtils.getReaderContent(new FileReader(file));
    }

    public static String getStreamContent(InputStream str) throws FileNotFoundException, IOException {
        return FileUtils.getReaderContent(new InputStreamReader(str));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getReaderContent(Reader r) throws IOException {
        StringBuffer contents = new StringBuffer();
        String lineSeparator = System.getProperty("line.separator");
        BufferedReader input = null;
        try {
            input = new BufferedReader(r);
            String line = null;
            while ((line = input.readLine()) != null) {
                contents.append(line);
                contents.append(lineSeparator);
            }
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception e) {}
            }
        }
        return contents.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFileContents(File file, String contents) throws FileNotFoundException, IOException {
        if (file == null) {
            throw new IllegalArgumentException("File should not be null.");
        }
        if (!file.exists()) {
            file.createNewFile();
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException("Should not be a directory: " + file);
        }
        if (!file.canWrite()) {
            throw new IllegalArgumentException("File cannot be written: " + file);
        }
        Writer output = null;
        try {
            output = new BufferedWriter(new FileWriter(file));
            output.write(contents);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(File file, byte[] content) throws IOException {
        RandomAccessFile raf = null;
        FileLock lock = null;
        try {
            raf = new RandomAccessFile(file, "rw");
            raf.setLength(content.length);
            long startTime = System.currentTimeMillis();
            while (true) {
                try {
                    lock = raf.getChannel().tryLock();
                    if (lock == null) {
                        throw new OverlappingFileLockException();
                    }
                }
                catch (OverlappingFileLockException ofle) {
                    if (System.currentTimeMillis() - startTime > 5000L) {
                        throw new IOException("File " + file.getName() + " locked");
                    }
                    FileUtils.waitABit(100L);
                    continue;
                }
                break;
            }
            raf.write(content);
        }
        finally {
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (Exception e) {}
            }
            if (lock != null) {
                try {
                    lock.release();
                }
                catch (Exception e) {}
            }
        }
    }

    private static void waitABit(long timeout) {
        try {
            Thread.sleep(timeout);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void writeFile(File file, String content) throws IOException {
        FileWriter fw = null;
        try {
            fw = new FileWriter(file);
            fw.write(content);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("Error writing file");
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File src, File dst) throws IOException {
        if (dst.isDirectory()) {
            dst = new File(dst, src.getName());
        }
        FileInputStream in = null;
        OutputStream out = null;
        try {
            int len;
            in = new FileInputStream(src);
            out = new FileOutputStream(dst);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (Exception e) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public static void copyDirectory(File srcDir, File dstDir) throws IOException {
        FileUtils.copyDirectory(srcDir, dstDir, true);
    }

    public static void copyDirectory(File srcDir, File dstDir, boolean recursive) throws IOException {
        if (srcDir.isDirectory()) {
            if (!dstDir.exists()) {
                dstDir.mkdirs();
            }
            String[] children = srcDir.list();
            for (int i = 0; i < children.length; ++i) {
                File srcFile = new File(srcDir, children[i]);
                if (!recursive && !srcFile.isFile()) continue;
                FileUtils.copyDirectory(srcFile, new File(dstDir, children[i]));
            }
        } else {
            FileUtils.copy(srcDir, dstDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] file2byte(File file) throws IOException {
        byte[] fileBuffer;
        FileChannel channel = null;
        try {
            channel = new FileInputStream(file).getChannel();
            MappedByteBuffer buf = channel.map(FileChannel.MapMode.READ_ONLY, 0L, (int)channel.size());
            fileBuffer = new byte[buf.capacity()];
            buf.get(fileBuffer, 0, fileBuffer.length);
        }
        finally {
            if (channel != null) {
                try {
                    channel.force(false);
                    channel.close();
                    channel = null;
                }
                catch (Exception exception) {}
            }
        }
        return fileBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void byte2File(File file, byte[] bytes) throws IOException {
        RandomAccessFile raf = null;
        FileChannel channel = null;
        try {
            raf = new RandomAccessFile(file, "rw");
            channel = raf.getChannel();
            channel.write(ByteBuffer.wrap(bytes));
        }
        finally {
            if (channel != null) {
                try {
                    channel.force(false);
                    channel.close();
                    channel = null;
                    raf.close();
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void makeJar(String classes, String jars, String filename) throws IOException, FileNotFoundException {
        ZipOutputStream jos = null;
        try {
            String jarname = filename.replace(SEPARATOR.charAt(0), '_');
            File file = new File(new File(classes), filename);
            File jarfile = new File(new File(jars), jarname);
            jos = new JarOutputStream(new FileOutputStream(jarfile + ".jar"));
            classes = new File(classes).toString() + SEPARATOR;
            FileUtils.recurseFiles(classes, file, (JarOutputStream)jos);
        }
        finally {
            if (jos != null) {
                try {
                    jos.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public static void recursiveDelete(File path) throws IOException {
        File[] files = path.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                FileUtils.recursiveDelete(files[i]);
            }
            files[i].delete();
        }
        path.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void recurseFiles(String root, File file, JarOutputStream jos) throws IOException, FileNotFoundException {
        block23: {
            block22: {
                if (!file.isDirectory()) break block22;
                String entry = FileUtils.substringAfter(file.toString(), root);
                entry = entry.replace(SEPARATOR.charAt(0), '/');
                JarEntry jarEntry = new JarEntry(entry + "/");
                try {
                    jos.putNextEntry(jarEntry);
                }
                finally {
                    try {
                        jos.closeEntry();
                    }
                    catch (Exception e) {}
                }
                String[] fileNames = file.list();
                if (fileNames == null) break block23;
                for (int i = 0; i < fileNames.length; ++i) {
                    FileUtils.recurseFiles(root, new File(file, fileNames[i]), jos);
                }
                break block23;
            }
            byte[] buf = new byte[1024];
            String entry = FileUtils.substringAfter(file.toString(), root);
            entry = entry.replace(SEPARATOR.charAt(0), '/');
            JarEntry jarEntry = new JarEntry(entry);
            BufferedInputStream in = null;
            try {
                int len;
                FileInputStream fin = new FileInputStream(file);
                in = new BufferedInputStream(fin);
                jos.putNextEntry(jarEntry);
                while ((len = in.read(buf)) > 0) {
                    jos.write(buf, 0, len);
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception e) {}
                }
                try {
                    jos.closeEntry();
                }
                catch (Exception e) {}
            }
        }
    }

    private static String substringAfter(String str, String separator) {
        if (str == null || str.length() == 0) {
            return str;
        }
        if (separator == null) {
            return "";
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return "";
        }
        return str.substring(pos + separator.length());
    }

    public static boolean compareObject(Object o1, Object o2) {
        return o1 == null && o2 == null || o1 != null && o2 != null && o1.toString().equals(o2.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File zipFile, File destPath, List<String> filesToExtract) throws IOException {
        if (!destPath.exists()) {
            destPath.mkdirs();
        }
        byte[] buf = new byte[1024];
        ZipInputStream zipInputStream = null;
        try {
            zipInputStream = new ZipInputStream(new FileInputStream(zipFile));
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                String entryName = zipEntry.getName();
                if (filesToExtract == null || filesToExtract.contains(entryName)) {
                    File destFile = new File(destPath, entryName);
                    if (!zipEntry.isDirectory()) {
                        int n;
                        File parentFile = destFile.getParentFile();
                        if (parentFile != null && !parentFile.exists()) {
                            parentFile.mkdirs();
                        }
                        FileOutputStream fileOutputStream = new FileOutputStream(destFile);
                        while ((n = zipInputStream.read(buf, 0, 1024)) > -1) {
                            fileOutputStream.write(buf, 0, n);
                        }
                        fileOutputStream.close();
                    }
                }
                zipInputStream.closeEntry();
                zipEntry = zipInputStream.getNextEntry();
            }
        }
        finally {
            if (zipInputStream != null) {
                try {
                    zipInputStream.close();
                }
                catch (Exception e) {}
            }
        }
    }
}

