/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.utils;

import com.tilab.wade.performer.descriptors.Parameter;
import jade.content.abs.AbsObject;
import jade.content.onto.AggregateHelper;
import jade.content.onto.BeanOntology;
import jade.content.onto.Ontology;
import jade.content.schema.ObjectSchema;
import jade.content.schema.TermSchema;
import jade.util.leap.List;
import java.lang.reflect.Array;

public class OntologyUtils {
    public static void addObjectToOntology(BeanOntology onto, Object value) throws Exception {
        if (value != null && !(value instanceof AbsObject)) {
            List jadeList;
            Class<?> valueClass = value.getClass();
            OntologyUtils.addClassToOntology(onto, valueClass);
            Object elementObj = null;
            if (valueClass.isArray() && Array.getLength(value) > 0) {
                elementObj = Array.get(value, 0);
            } else if (java.util.List.class.isAssignableFrom(valueClass)) {
                java.util.List javaList = (java.util.List)value;
                if (javaList.size() > 0) {
                    elementObj = javaList.get(0);
                }
            } else if (List.class.isAssignableFrom(valueClass) && (jadeList = (List)value).size() > 0) {
                elementObj = jadeList.get(0);
            }
            if (elementObj != null) {
                OntologyUtils.addClassToOntology(onto, elementObj.getClass());
            }
        }
    }

    public static void addActualParameterToOntology(BeanOntology onto, Parameter actualParam) throws Exception {
        Object value = actualParam.getValue();
        OntologyUtils.addObjectToOntology(onto, value);
    }

    public static void addFormalParameterToOntology(BeanOntology onto, Parameter formalParam, ClassLoader cl) throws Exception {
        Class paramClass = formalParam.getTypeClass(false, cl);
        OntologyUtils.addClassToOntology(onto, paramClass);
        Class elementParamClass = formalParam.getElementTypeClass(false, cl);
        if (elementParamClass != null) {
            OntologyUtils.addClassToOntology(onto, elementParamClass);
        }
    }

    public static void addClassToOntology(BeanOntology onto, Class clazz) throws Exception {
        if (clazz.isArray() && clazz != byte[].class || java.util.List.class.isAssignableFrom(clazz) || List.class.isAssignableFrom(clazz)) {
            return;
        }
        ObjectSchema schema = onto.getSchema(clazz);
        if (schema == null) {
            onto.add(clazz);
        }
    }

    public static ObjectSchema getParameterSchema(Parameter param, Ontology onto) throws Exception {
        return OntologyUtils.getParameterSchema(param, onto, null);
    }

    public static ObjectSchema getParameterSchema(Parameter param, Ontology onto, ClassLoader cl) throws Exception {
        ObjectSchema paramSchema = null;
        if (param.getSchema() != null) {
            paramSchema = param.getSchema();
        } else {
            Class paramClass = param.getTypeClass(false, cl);
            paramSchema = onto.getSchema(paramClass);
            if (paramSchema == null) {
                Class paramElementClass = param.getElementTypeClass(false, cl);
                ObjectSchema paramElementSchema = null;
                if (paramElementClass != null) {
                    paramElementSchema = onto.getSchema(paramElementClass);
                }
                paramSchema = AggregateHelper.getSchema((Class)paramClass, (TermSchema)((TermSchema)paramElementSchema));
            }
        }
        return paramSchema;
    }

    public static final Class getClassByName(String className, ClassLoader cl) throws Exception {
        if (className == null) {
            throw new Exception("Class-name not specified");
        }
        Class<?> clazz = OntologyUtils.getPrimitiveClassFromName(className);
        if (clazz == null) {
            clazz = cl == null ? Class.forName(className) : Class.forName(className, true, cl);
        }
        return clazz;
    }

    private static Class getPrimitiveClassFromName(String primitive) {
        if (primitive.equals("int")) {
            return Integer.TYPE;
        }
        if (primitive.equals("short")) {
            return Short.TYPE;
        }
        if (primitive.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (primitive.equals("byte")) {
            return Byte.TYPE;
        }
        if (primitive.equals("long")) {
            return Long.TYPE;
        }
        if (primitive.equals("double")) {
            return Double.TYPE;
        }
        if (primitive.equals("float")) {
            return Float.TYPE;
        }
        if (primitive.equals("char")) {
            return Character.TYPE;
        }
        return null;
    }
}

