/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.utils;

import jade.util.Logger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;

public class UriUtils {
    private static Logger logger = Logger.getMyLogger((String)UriUtils.class.getName());
    public static final String LOCALHOST = "localhost";
    public static final String PORT_SEPARATOR = ":";
    public static final int DEFAULT_PORT = -1;

    public static List toList(String s, String separator) {
        return Arrays.asList(s.split(separator));
    }

    public static String getLocalCanonicalHostname() {
        String hostname = null;
        try {
            hostname = InetAddress.getLocalHost().getCanonicalHostName().toLowerCase();
        }
        catch (UnknownHostException uhe) {
            logger.log(Logger.SEVERE, "getLocalCanonicalHostname(): no IP address for localhost!", (Throwable)uhe);
        }
        return hostname;
    }

    public static boolean compareHostNames(String host1, String host2) {
        if (host1.equalsIgnoreCase(host2)) {
            return true;
        }
        if (host1.equalsIgnoreCase(LOCALHOST)) {
            try {
                host1 = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception e) {
                logger.log(Logger.WARNING, "Cannot retrieve local host name.", (Throwable)e);
            }
        }
        if (host2 != null && host2.equalsIgnoreCase(LOCALHOST)) {
            try {
                host2 = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception e) {
                logger.log(Logger.WARNING, "Cannot retrieve local host name.", (Throwable)e);
            }
        }
        try {
            InetAddress[] host1Addrs = InetAddress.getAllByName(host1);
            InetAddress[] host2Addrs = InetAddress.getAllByName(host2);
            boolean isEqual = false;
            for (int i = 0; !isEqual && i < host1Addrs.length; ++i) {
                for (int j = 0; !isEqual && j < host2Addrs.length; ++j) {
                    isEqual = host1Addrs[i].equals(host2Addrs[j]);
                }
            }
            return isEqual;
        }
        catch (UnknownHostException uhe) {
            return false;
        }
    }

    public static String getLocalUrlString(int port) {
        return UriUtils.getLocalCanonicalHostname() + PORT_SEPARATOR + port;
    }

    public static String getLocalUrlString(String port) {
        String hostname = null;
        hostname = UriUtils.getLocalUrlString(Integer.parseInt(port));
        return hostname;
    }

    public static String getHostnameFromUrlString(String urlStr) {
        String hostname = urlStr;
        int i = urlStr.lastIndexOf(PORT_SEPARATOR);
        if (i >= 0) {
            hostname = urlStr.substring(0, i);
        }
        return hostname;
    }

    public static int getPortFromUrlString(String urlStr) {
        int port = -1;
        int i = urlStr.lastIndexOf(PORT_SEPARATOR);
        if (i >= 0) {
            String portStr = null;
            portStr = urlStr.substring(i + 1, urlStr.length());
            port = Integer.parseInt(portStr);
        }
        return port;
    }

    public static String hostsname2IP(String hostname) {
        String ip = null;
        try {
            ip = InetAddress.getByName(hostname).getHostAddress();
        }
        catch (UnknownHostException uhe) {
            logger.log(Logger.WARNING, "hostsname2IP(): hostname not correct!", (Throwable)uhe);
        }
        return ip;
    }

    public static String getLocalIP() {
        String ip = null;
        try {
            ip = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException uhe) {
            logger.log(Logger.WARNING, "getLocalIP(): no IP address for localhost!", (Throwable)uhe);
        }
        return ip;
    }

    private static void test() {
        System.out.println("getLocalCanonicalHostname()=\"" + UriUtils.getLocalCanonicalHostname() + "\"");
        System.out.println("getLocalUrlString(1234)=\"" + UriUtils.getLocalUrlString(1234) + "\"");
        System.out.println("getLocalUrlString(\"5678\")=\"" + UriUtils.getLocalUrlString("5678") + "\"");
        System.out.println("getHostnameFromUrlString(\"antbala.cselt.it:4566\")=\"" + UriUtils.getHostnameFromUrlString("antbala.cselt.it:4566") + "\"");
        System.out.println("getPortFromUrlString(\"antbala.cselt.it:4566\")=" + UriUtils.getPortFromUrlString("antbala.cselt.it:4566"));
        System.out.println("getHostnameFromUrlString(\"antbala.cselt.it\")=\"" + UriUtils.getHostnameFromUrlString("antbala.cselt.it") + "\"");
        System.out.println("getPortFromUrlString(\"antbala.cselt.it\")=" + UriUtils.getPortFromUrlString("antbala.cselt.it"));
    }

    public static void main(String[] args) throws Exception {
        UriUtils.test();
    }
}

