/*
 * Decompiled with CFR 0.152.
 */
package com.tilab.wade.wsma.ontology;

import com.tilab.wade.performer.descriptors.Parameter;
import com.tilab.wade.wsma.ontology.WorkflowParameterInfo;
import jade.content.Concept;
import jade.content.onto.annotations.Slot;
import jade.content.onto.annotations.SuppressSlot;
import jade.core.AID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowExecutionInfo
implements Concept {
    private static final long serialVersionUID = -3197445999119132533L;
    public static final String EXECUTION_ID_FIELD = "wi.executionId";
    public static final String NAME_FIELD = "wi.name";
    public static final String DOCUMENTATION_FIELD = "wi.documentation";
    public static final String PARENT_EXECUTION_ID_FIELD = "wi.parentExecutionid";
    public static final String WORKFLOW_ID_FIELD = "wi.workflowId";
    public static final String SESSION_ID_FIELD = "wi.sessionId";
    public static final String REQUESTER_FIELD = "wi.requester";
    public static final String EXECUTOR_FIELD = "wi.executorName";
    public static final String LONG_RUNNING_FIELD = "wi.longRunning";
    public static final String TRANSACTIONAL_FIELD = "wi.transactional";
    public static final String STATUS_FIELD = "wi.statusName";
    public static final String START_TIME_FIELD = "wi.startTime";
    public static final String LAST_UPDATE_TIME_FIELD = "wi.lastUpdateTime";
    public static final String RESULT_FIELD = "wi.resultName";
    public static final String ERROR_MESSAGE_FIELD = "wi.errorMessage";
    public static final String WF_CURRENT_ACTIVITY_FIELD = "wi.workflowCurrentActivity";
    public static final String PARAMETERS_FIELD = "wi.parameters";
    private String executionId;
    private String name;
    private String documentation;
    private String parentExecutionid;
    private String workflowId;
    private String sessionId;
    private String requester;
    private String executorName;
    private boolean longRunning;
    private boolean transactional;
    private boolean interactive;
    private WorkflowStatus status;
    private long startTime;
    private long lastUpdateTime;
    private WorkflowResult result;
    private String errorMessage;
    private String workflowCurrentActivity;
    private List<WorkflowParameterInfo> parameters = new ArrayList<WorkflowParameterInfo>();

    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executorId) {
        this.executionId = executorId;
    }

    @Slot(mandatory=false)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Slot(mandatory=false)
    public String getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    @Slot(mandatory=false)
    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    @Slot(mandatory=false)
    public String getRequester() {
        return this.requester;
    }

    public void setRequester(String requester) {
        this.requester = requester;
    }

    public String getExecutorName() {
        return this.executorName;
    }

    public void setExecutorName(String executorName) {
        this.executorName = executorName;
    }

    @SuppressSlot
    public AID getExecutor() {
        return new AID(this.executorName, true);
    }

    public WorkflowStatus getStatus() {
        return this.status;
    }

    public void setStatus(WorkflowStatus status) {
        this.status = status;
    }

    private String getStatusName() {
        return this.status.name();
    }

    private void setStatusName(String statusName) {
        this.status = WorkflowStatus.valueOf(statusName);
    }

    @Slot(mandatory=false)
    public String getParentExecutionid() {
        return this.parentExecutionid;
    }

    public void setParentExecutionid(String parentExecutionid) {
        this.parentExecutionid = parentExecutionid;
    }

    public String getWorkflowId() {
        return this.workflowId;
    }

    public void setWorkflowId(String workflowId) {
        this.workflowId = workflowId;
    }

    public void setLongRunning(boolean longRunning) {
        this.longRunning = longRunning;
    }

    public boolean isLongRunning() {
        return this.longRunning;
    }

    public void setTransactional(boolean transactional) {
        this.transactional = transactional;
    }

    public boolean isTransactional() {
        return this.transactional;
    }

    public void setInteractive(boolean interactive) {
        this.interactive = interactive;
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(long lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    @Slot(mandatory=false)
    public WorkflowResult getResult() {
        return this.result;
    }

    public void setResult(WorkflowResult result) {
        this.result = result;
    }

    private String getResultName() {
        if (this.result != null) {
            return this.result.name();
        }
        return null;
    }

    private void setResultName(String resultName) {
        this.result = resultName != null ? WorkflowResult.valueOf(resultName) : null;
    }

    @Slot(mandatory=false)
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    @Slot(mandatory=false)
    public String getWorkflowCurrentActivity() {
        return this.workflowCurrentActivity;
    }

    public void setWorkflowCurrentActivity(String workflowCurrentActivity) {
        this.workflowCurrentActivity = workflowCurrentActivity;
    }

    public List<WorkflowParameterInfo> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<WorkflowParameterInfo> parameters) {
        this.parameters = parameters;
    }

    public void setWadeParameters(List<Parameter> wadeParameters) {
        if (wadeParameters != null) {
            this.parameters = new ArrayList<WorkflowParameterInfo>();
            for (int i = 0; i < wadeParameters.size(); ++i) {
                Parameter param = wadeParameters.get(i);
                WorkflowParameterInfo wpi = this.createWorkflowParameterInfo(param);
                this.parameters.add(wpi);
            }
        }
    }

    public void updateWadeParameters(List<Parameter> wadeParameters) {
        if (wadeParameters != null) {
            HashMap<String, WorkflowParameterInfo> wpisMap = new HashMap<String, WorkflowParameterInfo>();
            for (WorkflowParameterInfo wpi : this.parameters) {
                wpisMap.put(wpi.getName(), wpi);
            }
            for (int i = 0; i < wadeParameters.size(); ++i) {
                Parameter param = wadeParameters.get(i);
                WorkflowParameterInfo wpi = (WorkflowParameterInfo)wpisMap.get(param.getName());
                if (wpi != null) {
                    wpi.setValue(this.formatValue(param.getValue()));
                    continue;
                }
                wpi = this.createWorkflowParameterInfo(param);
                if (wpi == null) continue;
                this.parameters.add(wpi);
            }
        }
    }

    private WorkflowParameterInfo createWorkflowParameterInfo(Parameter parameter) {
        if (parameter.getType() == null && parameter.getValue() == null) {
            return null;
        }
        WorkflowParameterInfo wpi = new WorkflowParameterInfo();
        wpi.setExecutionId(this.executionId);
        wpi.setName(parameter.getName());
        wpi.setMode(parameter.getMode());
        wpi.setType(parameter.getType());
        if (wpi.getType() == null) {
            wpi.setType(parameter.getValue().getClass().getCanonicalName());
        }
        wpi.setValue(this.formatValue(parameter.getValue()));
        wpi.setDocumentation(parameter.getDocumentation());
        return wpi;
    }

    private String formatValue(Object value) {
        return value != null ? value.toString() : null;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof WorkflowExecutionInfo)) {
            return false;
        }
        WorkflowExecutionInfo otherWEI = (WorkflowExecutionInfo)other;
        return this.getExecutionId().equals(otherWEI.getExecutionId());
    }

    public int hashCode() {
        return this.getExecutionId().hashCode();
    }

    public String toString() {
        return "WorkflowExecutionInfo [executionId=" + this.executionId + ", parentExecutionid=" + this.parentExecutionid + ", workflowId=" + this.workflowId + ", sessionId=" + this.sessionId + ", requester=" + this.requester + ", executorName=" + this.executorName + ", status=" + (Object)((Object)this.status) + ", startTime=" + this.startTime + ", lastUpdateTime=" + this.lastUpdateTime + ", result=" + (Object)((Object)this.result) + ", errorMessage=" + this.errorMessage + ", workflowCurrentActivity=" + this.workflowCurrentActivity + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WorkflowResult {
        OK,
        KO,
        TRANSACTION_FAIL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WorkflowStatus {
        ACTIVE,
        FROZEN,
        SUSPENDED,
        WAIT_COMMIT,
        ROLLBACK,
        TERMINATED;

    }
}

